﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO.Ports;

namespace usb_opto
{
    public partial class Form1 : Form
    {
        static SerialPort USB_PORT;
        byte[] SerBuf = new byte[64];
        byte usb_found = 0;
        byte relay_states = 0;
        byte opto_states = 0;

        public Form1()
        {
            InitializeComponent();
            USB_PORT = new SerialPort();
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void transmit(byte write_bytes)
        {
            try
            {
                if (usb_found == 1) USB_PORT.Write(SerBuf, 0, write_bytes);      // writes specified amount of SerBuf out on COM port
            }
            catch (Exception)
            {
                usb_found = 0;
                MessageBox.Show("write fail");
                return;
            }
        }

        private void receive(byte read_bytes)
        {
            byte x;
            for (x = 0; x < read_bytes; x++)       // this will call the read function for the passed number times, 
            {                                      // this way it ensures each byte has been correctly recieved while
                try                                // still using timeouts
                {
                    if (usb_found == 1) USB_PORT.Read(SerBuf, x, 1);     // retrieves 1 byte at a time and places in SerBuf at position x
                }
                catch (Exception)                                       // timeout or other error occured, set lost comms indicator
                {
                    usb_found = 0;
                    MessageBox.Show("read fail");
                    return;
                }
            }
        }

        private void comboBox_comport_MouseDown(object sender, MouseEventArgs e)
        {
            // Grab the list of available COM ports and place them in the combo box
            comboBox_comport.Items.Clear();
            string[] comportnames = new string[100];
            comportnames = SerialPort.GetPortNames();
            var sortedList = comportnames.OrderBy(port => Convert.ToInt32(port.Replace("COM", string.Empty)));
            foreach (string port in sortedList)
            {
                comboBox_comport.Items.Add(port);                      // places each "COMx" name into combobox
            }
        }

        private void comboBox_comport_SelectedIndexChanged(object sender, EventArgs e)
        {
            timer1.Stop();
            try
            {
                if (USB_PORT.IsOpen) USB_PORT.Close(); // close any existing handle
            }
            catch
            {
                MessageBox.Show("Error closing to COM port", "USB-OPTO", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
                Application.Exit();
            }
            try
            {
                USB_PORT.PortName = comboBox_comport.Text;    // retrieves "COMx" from selection in combo box
                USB_PORT.ReadTimeout = 500;
                USB_PORT.WriteTimeout = 500;
                USB_PORT.Open();
                usb_found = 1;
                timer1.Enabled = true;
                timer1.Start();

                // Get module info
                SerBuf[0] = 0x5A;
                transmit(1);
                receive(2);
                relay_states = SerBuf[0];
                label_id.Text = "Module id : " + SerBuf[0].ToString();
                label_ver.Text = "Firmware v : " + SerBuf[1].ToString();

                // Get opto states
                SerBuf[0] = 0x19;
                transmit(1);
                receive(1);
                opto_states = SerBuf[0];

                // Get the relay states
                SerBuf[0] = 0x5B;
                transmit(1);
                receive(1);
                relay_states = SerBuf[0];

                // Enable controls
                button_r1.Enabled = true;
                button_r2.Enabled = true;
                button_r3.Enabled = true;
                button_r4.Enabled = true;
                button_r5.Enabled = true;
                button_r6.Enabled = true;
                button_r7.Enabled = true;
                button_r8.Enabled = true;

                radioButton_opt1.Enabled = true;
                radioButton_opt2.Enabled = true;
                radioButton_opt3.Enabled = true;
                radioButton_opt4.Enabled = true;
                radioButton_opt5.Enabled = true;
                radioButton_opt6.Enabled = true;
                radioButton_opt7.Enabled = true;
                radioButton_opt8.Enabled = true;
            }
            catch
            {
                MessageBox.Show("Error opening to COM port", "USB-OPTO", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
                usb_found = 0;
                timer1.Stop();
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (usb_found == 1)
            {
                // Get the relay states
                SerBuf[0] = 0x5B;
                transmit(1);
                receive(1);
                relay_states = SerBuf[0];

                // Set the button background colours according to the relay states
                if ((relay_states & 0x01) == 0) button_r1.BackColor = Color.White;
                else button_r1.BackColor = Color.Red;
                if ((relay_states & (0x01 << 1)) == 0) button_r2.BackColor = Color.White;
                else button_r2.BackColor = Color.Red;
                if ((relay_states & (0x01 << 2)) == 0) button_r3.BackColor = Color.White;
                else button_r3.BackColor = Color.Red;
                if ((relay_states & (0x01 << 3)) == 0) button_r4.BackColor = Color.White;
                else button_r4.BackColor = Color.Red;
                if ((relay_states & (0x01 << 4)) == 0) button_r5.BackColor = Color.White;
                else button_r5.BackColor = Color.Red;
                if ((relay_states & (0x01 << 5)) == 0) button_r6.BackColor = Color.White;
                else button_r6.BackColor = Color.Red;
                if ((relay_states & (0x01 << 6)) == 0) button_r7.BackColor = Color.White;
                else button_r7.BackColor = Color.Red;
                if ((relay_states & (0x01 << 7)) == 0) button_r8.BackColor = Color.White;
                else button_r8.BackColor = Color.Red;

                // Get opto states
                SerBuf[0] = 0x19;
                transmit(1);
                receive(1);
                opto_states = SerBuf[0];

                if ((opto_states & 0x01) == 0) radioButton_opt1.Checked = false;
                else radioButton_opt1.Checked = true;
                if ((opto_states & (0x01 << 1)) == 0) radioButton_opt2.Checked = false;
                else radioButton_opt2.Checked = true;
                if ((opto_states & (0x01 << 2)) == 0) radioButton_opt3.Checked = false;
                else radioButton_opt3.Checked = true;
                if ((opto_states & (0x01 << 3)) == 0) radioButton_opt4.Checked = false;
                else radioButton_opt4.Checked = true;
                if ((opto_states & (0x01 << 4)) == 0) radioButton_opt5.Checked = false;
                else radioButton_opt5.Checked = true;
                if ((opto_states & (0x01 << 5)) == 0) radioButton_opt6.Checked = false;
                else radioButton_opt6.Checked = true;
                if ((opto_states & (0x01 << 6)) == 0) radioButton_opt7.Checked = false;
                else radioButton_opt7.Checked = true;
                if ((opto_states & (0x01 << 7)) == 0) radioButton_opt8.Checked = false;
                else radioButton_opt8.Checked = true;
            }
        }

        private void button_pressed(object sender, MouseEventArgs e)
        {
            // Check type of sender to make sure it is a button
            if (sender is Button)
            {
                if (usb_found == 1)
                {
                    Button button = (Button)sender;
                    // Check the title of the button for which realy we wish to change
                    // And then check the state of that relay and send the appropriate command to turn it on or off
                    switch (button.Text.ToString())
                    {
                        case "Relay 1":
                            if ((relay_states & 0x01) == 0) SerBuf[0] = 0x65;
                            else SerBuf[0] = 0x6F;
                            break;
                        case "Relay 2":
                            if ((relay_states & (0x01 << 1)) == 0) SerBuf[0] = 0x66;
                            else SerBuf[0] = 0x70;
                            break;
                        case "Relay 3":
                            if ((relay_states & (0x01 << 2)) == 0) SerBuf[0] = 0x67;
                            else SerBuf[0] = 0x71;
                            break;
                        case "Relay 4":
                            if ((relay_states & (0x01 << 3)) == 0) SerBuf[0] = 0x68;
                            else SerBuf[0] = 0x72;
                            break;
                        case "Relay 5":
                            if ((relay_states & (0x01 << 4)) == 0) SerBuf[0] = 0x69;
                            else SerBuf[0] = 0x73;
                            break;
                        case "Relay 6":
                            if ((relay_states & (0x01 << 5)) == 0) SerBuf[0] = 0x6A;
                            else SerBuf[0] = 0x74;
                            break;
                        case "Relay 7":
                            if ((relay_states & (0x01 << 6)) == 0) SerBuf[0] = 0x6B;
                            else SerBuf[0] = 0x75;
                            break;
                        case "Relay 8":
                            if ((relay_states & (0x01 << 7)) == 0) SerBuf[0] = 0x6C;
                            else SerBuf[0] = 0x76;
                            break;
                    }
                    transmit(1);
                }
            }
        }


    }
}
