//
//  ViewController.m
//  usb-opto
//
//  Created by James Henderson on 28/09/2016.
//  Copyright © 2016 Devantech Ltd. All rights reserved.
//

#import "ViewController.h"

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // this notification listens for when you click on the serial drop down and calls refreshSerialList
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(refreshSerialList:) name:@"NSPopUpButtonWillPopUpNotification" object:nil];
}

- (void)setRepresentedObject:(id)representedObject {
    [super setRepresentedObject:representedObject];
    
    // Update the view, if already loaded.
}

- (void) viewDidDisappear {
    [super viewDidDisappear];
    [self closePort];
}

/*
 *
 *  Pop up button functions.
 *
 */

// Called when serial port selected from serial port list
- (IBAction)serialPortSelected:(id)sender{
    [self closePort];
    if ([self openPort:[serialList titleOfSelectedItem]]){
        
        // Get the firmware version and module id
        serBuf[0] = 0x5A;
        [self transmit:1];
        [self receive:2];
        
        // Display the firmware version and module id
        NSString *verString = [NSString stringWithFormat:@"Firmware v : %d", serBuf[1]];
        NSString *idString = [NSString stringWithFormat:@"Module id : %d", serBuf[0]];
        [firmwareLabel setStringValue:verString];
        [idLabel setStringValue:idString];
        
        // Get the relay states
        serBuf[0] = 0x5B;
        [self transmit:1];
        [self receive:1];
        relaystates = serBuf[0];
        
        // get the opto states
        serBuf[0] = 0x19;
        [self transmit:1];
        [self receive:1];
        optostates = serBuf[0];
        
        [self setButtonColours];
        
        relay1Button.enabled = true;
        relay2Button.enabled = true;
        relay3Button.enabled = true;
        relay4Button.enabled = true;
        relay5Button.enabled = true;
        relay6Button.enabled = true;
        relay7Button.enabled = true;
        relay8Button.enabled = true;
        opto1Button.enabled = true;
        opto2Button.enabled = true;
        opto3Button.enabled = true;
        opto4Button.enabled = true;
        opto5Button.enabled = true;
        opto6Button.enabled = true;
        opto7Button.enabled = true;
        opto8Button.enabled = true;
        
        [NSTimer scheduledTimerWithTimeInterval:0.1 target:self selector:@selector(timerTick:) userInfo:NULL repeats:NO];
    }
}

- (void) refreshSerialList:(NSNotification*) notification{
    io_object_t sPort;
    io_iterator_t serialPortIterator;
    
    NSString *selectedItem = [serialList titleOfSelectedItem];       // Store selected item so it can be reselected
    
    [serialList removeAllItems];                                     // Clear entries in serial port list
    
    IOServiceGetMatchingServices(kIOMasterPortDefault, IOServiceMatching(kIOSerialBSDServiceValue), &serialPortIterator);   // ask for all serial ports
    
    while ((sPort = IOIteratorNext(serialPortIterator))) {          // loop through ports and add them to an array
        [serialList addItemWithTitle:(__bridge NSString*)IORegistryEntryCreateCFProperty(sPort, CFSTR(kIOCalloutDeviceKey),  kCFAllocatorDefault, 0)];
        IOObjectRelease(sPort);
    }
    
    [serialList insertItemWithTitle:@"Select Serial Port" atIndex:0];
    [serialList selectItemWithTitle:selectedItem];
    if (serialList.indexOfSelectedItem < 0) [serialList selectItemAtIndex:0];
    IOObjectRelease(serialPortIterator);
}

/*
 *
 *  Button functions
 *
 */

- (void) buttonPressed:(id)sender
{
    if ([sender isKindOfClass:[NSButton class]]) {              // Make sure the control sending the message is a button
        NSButton *button = (NSButton*)sender;
        NSString *st = button.title;                            // Get the title of the button
        char relay = [st characterAtIndex:(st.length - 1)];     // Get the last char of the title which is the relay number
        switch (relay) {                                        // Find which relay we wish to change and put the command in serBuf[0] to either turn it on or off
            case '1':                                   // Relay 1
                if (!(relaystates & 0x01)) {            // Check state of relay
                    serBuf[0] = 0x65;                   // Relay 1 on
                } else {
                    serBuf[0] = 0x6F;                   // Relay 1 off
                }
                break;
            case '2':
                if (!(relaystates & (0x01 << 1))) {
                    serBuf[0] = 0x66;
                } else {
                    serBuf[0] = 0x70;
                }
                break;
            case '3':
                if (!(relaystates & (0x01 << 2))) {
                    serBuf[0] = 0x67;
                } else {
                    serBuf[0] = 0x71;
                }
                break;
            case '4':
                if (!(relaystates & (0x01 << 3))) {
                    serBuf[0] = 0x68;
                } else {
                    serBuf[0] = 0x72;
                }
                break;
            case '5':
                if (!(relaystates & (0x01 << 4))) {
                    serBuf[0] = 0x69;
                } else {
                    serBuf[0] = 0x73;
                }
                break;
            case '6':
                if (!(relaystates & (0x01 << 5))) {
                    serBuf[0] = 0x6A;
                } else {
                    serBuf[0] = 0x74;
                }
                break;
            case '7':
                if (!(relaystates & (0x01 << 6))) {
                    serBuf[0] = 0x6B;
                } else {
                    serBuf[0] = 0x75;
                }
                break;
            case '8':
                if (!(relaystates & (0x01 << 7))) {
                    serBuf[0] = 0x6C;
                } else {
                    serBuf[0] = 0x76;
                }
                break;
            default:
                break;
        }
    }
    [self transmit:1];      // Send the command
}

- (void) setButtonColours
{
    if (relaystates & 0x01) {
        [relay1Button setState:1];
    } else {
        [relay1Button setState:0];
    }
    
    if (relaystates & (0x01 << 1)) {
        [relay2Button setState:1];
    } else {
        [relay2Button setState:0];
    }
    
    if (relaystates & (0x01 << 2)) {
        [relay3Button setState:1];
    } else {
        [relay3Button setState:0];
    }
    
    if (relaystates & (0x01 << 3)) {
        [relay4Button setState:1];
    } else {
        [relay4Button setState:0];
    }
    
    if (relaystates & (0x01 << 4)) {
        [relay5Button setState:1];
    } else {
        [relay5Button setState:0];
    }
    
    if (relaystates & (0x01 << 5)) {
        [relay6Button setState:1];
    } else {
        [relay6Button setState:0];
    }
    
    if (relaystates & (0x01 << 6)) {
        [relay7Button setState:1];
    } else {
        [relay7Button setState:0];
    }
    
    if (relaystates & (0x01 << 7)) {
        [relay8Button setState:1];
    } else {
        [relay8Button setState:0];
    }
    
    if (optostates & 0x01) {
        [opto1Button setState:1];
    } else {
        [opto1Button setState:0];
    }
    
    if (optostates & (0x01 << 1)) {
        [opto2Button setState:1];
    } else {
        [opto2Button setState:0];
    }
    
    if (optostates & (0x01 << 2)) {
        [opto3Button setState:1];
    } else {
        [opto3Button setState:0];
    }
    
    if (optostates & (0x01 << 3)) {
        [opto4Button setState:1];
    } else {
        [opto4Button setState:0];
    }
    
    if (optostates & (0x01 << 4)) {
        [opto5Button setState:1];
    } else {
        [opto5Button setState:0];
    }
    
    if (optostates & (0x01 << 5)) {
        [opto6Button setState:1];
    } else {
        [opto6Button setState:0];
    }
    
    if (optostates & (0x01 << 6)) {
        [opto7Button setState:1];
    } else {
        [opto7Button setState:0];
    }
    
    if (optostates & (0x01 << 7)) {
        [opto8Button setState:1];
    } else {
        [opto8Button setState:0];
    }
    
}

/*
 *
 *  Timer functions.
 *
 */

- (void) timerTick:(NSTimer *)t
{
    if (isConnected == TRUE) {
        
        // Get the relay states
        serBuf[0] = 0x5B;
        [self transmit:1];
        [self receive:1];
        relaystates = serBuf[0];
        
        // get the opto states
        serBuf[0] = 0x19;
        [self transmit:1];
        [self receive:1];
        optostates = serBuf[0];
        
        [self setButtonColours];
        
        [NSTimer scheduledTimerWithTimeInterval:0.1 target:self selector:@selector(timerTick:) userInfo:NULL repeats:NO];
    }
}

/*
 *
 *  Serial port functions.
 *
 */

- (BOOL) openPort:(NSString*)portName
{
    
    struct termios options;
    
    const char *path = [portName UTF8String];
    
    fd = open(path , O_RDWR | O_NOCTTY | O_NONBLOCK);   // open the port
    
    if (fd == -1) {
        [self showAlertWithString:[NSString stringWithFormat:@"Error opening port : %s(%d).\n", strerror(errno), errno]];
        isConnected = FALSE;
        return FALSE;
    }
    
    
    if (ioctl(fd, TIOCEXCL) == -1)                      // Stop repeated opens on this port
    {
        [self showAlertWithString:@"Error setting TIOCEXCL\n"];
        close(fd);
        isConnected = FALSE;
        return FALSE;
    }
    
    if (fcntl(fd, F_SETFL, 0) == -1)                    // Make the port blocking
    {
        [self showAlertWithString:@"Error clearing O_NONBLOCK \n"];
        close(fd);
        isConnected = FALSE;
        return FALSE;
    }
    
    if (tcgetattr(fd, &originalOptions) == -1)          // Get the ports original options
    {
        [self showAlertWithString:@"Error getting tty attributes \n"];
        close(fd);
        isConnected = FALSE;
        return FALSE;
    }
    
    
    options = originalOptions;
    
    cfmakeraw(&options);
    
    cfsetspeed(&options, B19200);                       // Set 19200 baud
    cfsetospeed(&options, B19200);
    
    options.c_cflag |= (CLOCAL | CREAD);				// Enable the receiver and set local mode
    options.c_cflag &= ~PARENB;                         // No parity bit
    
    options.c_cflag |= CSTOPB;                          // Set 2 stop bits
    
    options.c_cflag &= ~CSIZE;                          // Set the character size
    options.c_cflag |= CS8;
    
    if (tcsetattr(fd, TCSANOW, &options) == -1)
    {
        [self showAlertWithString:@"Error setting tty attributes \n"];
        close(fd);
        isConnected = FALSE;
        return FALSE;
    }
    
    isConnected = TRUE;
    
    return isConnected;
    
}

- (void) closePort                                      // Reset port options and close port
{
    if (isConnected) {
        if (tcsetattr(fd, TCSANOW, &originalOptions) == -1)
        {
            [self showAlertWithString:@"SerialController --> closePort : Error resetting tty attributes"];
        }
        isConnected = FALSE;
        close(fd);
    }
}

- (void) transmit:(int)bytes
{
    char result = write(fd, serBuf, bytes);
    tcdrain(fd); // wait for all data to be written
    if (result == -1) {
        [self showAlertWithString:@"Error writing to device"];
    }
}

- (void) receive:(int)bytes
{
    size_t result = read(fd, serBuf, bytes);
    if (result != bytes) {
        [self showAlertWithString:@"Error reading data"];
    }
}

/*
 *
 *  Error alert box
 *
 */

- (void) showAlertWithString:(NSString*)title
{
    NSAlert *alert = [[NSAlert alloc] init];
    [alert addButtonWithTitle:@"OK"];
    [alert setMessageText:title];
    [alert setAlertStyle:NSCriticalAlertStyle];
    [alert runModal];
    [self closePort];
    
}

@end

