﻿Public Class Form1

    Dim serialport As New System.IO.Ports.SerialPort    ' Declares a handle for COM port
    Dim serBuf(20) As Byte                              ' A global accessable array for data to be buffered for the COMX port
    Dim states As Integer = 0
    Dim optos As Integer = 0

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        ' Show all available COM ports.
        For Each sp As String In My.Computer.Ports.SerialPortNames
            ComboBox_comport().Items.Add(sp)            ' Adds COMX to listbox called "comportselect"
        Next
        ComboBox_comport.Text = "Select COM Port"       ' Adds the message when program is first loaded
    End Sub

    Private Sub ComboBox_comport_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox_comport.SelectedIndexChanged
        If (serialport.IsOpen) Then                                                                 ' If program has previously opened a COM port, start by closing it
            serialport.Close()
        End If
        Try
            serialport = My.Computer.Ports.OpenSerialPort(ComboBox_comport.Text, 19200, 0, 8, 2)    ' attempt to open a new COM port
        Catch                                                                                       ' Catch open failures
            MessageBox.Show("Failed to open COM port", "USB-OPTO", MessageBoxButtons.OKCancel, MessageBoxIcon.Asterisk)
            Return
        End Try
        serialport.ReadTimeout = 1000                                                               ' We will only arrive here on successfull open

        serBuf(0) = &H5A                                                                            ' Get id and firmware version
        transmit(1)
        receive(2)

        Dim idstr As String = String.Format("Module ID:{0}", serBuf(0))
        Dim verstr As String = String.Format("Firmware v:{0}", serBuf(1))
        Label_id.Text = idstr
        Label_v.Text = verstr

        Button_relay_1.Enabled = True
        Button_relay_2.Enabled = True
        Button_relay_3.Enabled = True
        Button_relay_4.Enabled = True
        Button_relay_5.Enabled = True
        Button_relay_6.Enabled = True
        Button_relay_7.Enabled = True
        Button_relay_8.Enabled = True
        Timer1.Enabled = True
    End Sub

    Private Sub transmit(num As Integer)
        If serialport.IsOpen Then
            Try
                serialport.Write(serBuf, 0, num)        ' writes specified amount of SerBuf out on COM port
            Catch
                serialport.Close()
                Timer1.Enabled = False
                MessageBox.Show("Failed to read from COM port", "ERROR!", MessageBoxButtons.OKCancel, MessageBoxIcon.Asterisk)
                Return
            End Try
        End If
    End Sub

    Private Sub receive(num As Integer)
        If serialport.IsOpen Then
            Dim x As Integer = 0
            For x = 0 To num - 1                           ' Call the read function for passed number of times
                Try                                     ' This way we receive the correct number of bytes while still using timeouts
                    serialport.Read(serBuf, x, 1)
                Catch ex As Exception
                    serialport.Close()
                    Timer1.Enabled = False
                    MessageBox.Show("Failed to read from COM port", "ERROR!", MessageBoxButtons.OKCancel, MessageBoxIcon.Asterisk)
                End Try
            Next x
        End If
    End Sub

    Private Sub Timer1_Tick(sender As Object, e As EventArgs) Handles Timer1.Tick
        If serialport.IsOpen Then
            serBuf(0) = &H5B
            transmit(1)
            receive(1)
            states = serBuf(0)

            ' Set button colours
            If states And &H1 Then
                Button_relay_1.BackColor = Color.Red
            Else
                Button_relay_1.BackColor = Color.White
            End If

            If states And &H2 Then
                Button_relay_2.BackColor = Color.Red
            Else
                Button_relay_2.BackColor = Color.White
            End If

            If states And &H4 Then
                Button_relay_3.BackColor = Color.Red
            Else
                Button_relay_3.BackColor = Color.White
            End If

            If states And &H8 Then
                Button_relay_4.BackColor = Color.Red
            Else
                Button_relay_4.BackColor = Color.White
            End If

            If states And &H10 Then
                Button_relay_5.BackColor = Color.Red
            Else
                Button_relay_5.BackColor = Color.White
            End If

            If states And &H20 Then
                Button_relay_6.BackColor = Color.Red
            Else
                Button_relay_6.BackColor = Color.White
            End If

            If states And &H40 Then
                Button_relay_7.BackColor = Color.Red
            Else
                Button_relay_7.BackColor = Color.White
            End If

            If states And &H80 Then
                Button_relay_8.BackColor = Color.Red
            Else
                Button_relay_8.BackColor = Color.White
            End If

            serBuf(0) = &H19                                            ' Get the opto values
            transmit(1)
            receive(1)

            optos = serBuf(0)

            If optos And &H1 Then
                RadioButton_opt1.Checked = True
            Else
                RadioButton_opt1.Checked = False
            End If

            If optos And &H2 Then
                RadioButton_opt2.Checked = True
            Else
                RadioButton_opt2.Checked = False
            End If

            If optos And &H4 Then
                RadioButton_opt3.Checked = True
            Else
                RadioButton_opt3.Checked = False
            End If

            If optos And &H8 Then
                RadioButton_opt4.Checked = True
            Else
                RadioButton_opt4.Checked = False
            End If

            If optos And &H10 Then
                RadioButton_opt5.Checked = True
            Else
                RadioButton_opt5.Checked = False
            End If

            If optos And &H20 Then
                RadioButton_opt6.Checked = True
            Else
                RadioButton_opt6.Checked = False
            End If

            If optos And &H40 Then
                RadioButton_opt7.Checked = True
            Else
                RadioButton_opt7.Checked = False
            End If

            If optos And &H80 Then
                RadioButton_opt8.Checked = True
            Else
                RadioButton_opt8.Checked = False
            End If
        End If
    End Sub

    Private Sub button_pressed(sender As Object, e As EventArgs) Handles Button_relay_1.Click, Button_relay_2.Click, Button_relay_3.Click, Button_relay_4.Click, Button_relay_5.Click, Button_relay_6.Click, Button_relay_7.Click, Button_relay_8.Click
        If TypeOf sender Is Button Then                         ' Check that is is a button sending the message
            Dim btn As Button = DirectCast(sender, Button)      ' Get the button
            If serialport.IsOpen Then
                Select Case btn.Text                            ' Check buttons text to see what relay we are expecting to toggle
                    Case "Relay 1"
                        If states And &H1 Then                  ' Check state of relay to see if we need to turn it on or off
                            serBuf(0) = &H6F                    ' Relay 1 on command
                        Else
                            serBuf(0) = &H65                    ' Relay 1 off command
                        End If
                    Case "Relay 2"
                        If states And &H2 Then
                            serBuf(0) = &H70
                        Else
                            serBuf(0) = &H66
                        End If
                    Case "Relay 3"
                        If states And &H4 Then
                            serBuf(0) = &H71
                        Else
                            serBuf(0) = &H67
                        End If
                    Case "Relay 4"
                        If states And &H8 Then
                            serBuf(0) = &H72
                        Else
                            serBuf(0) = &H68
                        End If
                    Case "Relay 5"
                        If states And &H10 Then
                            serBuf(0) = &H73
                        Else
                            serBuf(0) = &H69
                        End If
                    Case "Relay 6"
                        If states And &H20 Then
                            serBuf(0) = &H74
                        Else
                            serBuf(0) = &H6A
                        End If
                    Case "Relay 7"
                        If states And &H40 Then
                            serBuf(0) = &H75
                        Else
                            serBuf(0) = &H6B
                        End If
                    Case "Relay 8"
                        If states And &H80 Then
                            serBuf(0) = &H76
                        Else
                            serBuf(0) = &H6C
                        End If
                End Select
                transmit(1)                                     ' Send the command
            End If
        End If
    End Sub
End Class
