﻿Public Class Form1

    Dim serialport As New System.IO.Ports.SerialPort    ' Declares a handle for COM port
    Dim serBuf(20) As Byte                              ' A global accessable array for data to be buffered for the COMX port
    Dim states As Integer = 0
    Dim connected As Boolean = False
    Dim adc1 As Integer
    Dim adc2 As Integer
    Dim adc3 As Integer
    Dim adc4 As Integer
    Dim adc5 As Integer
    Dim adc6 As Integer
    Dim adc7 As Integer
    Dim adc8 As Integer

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        ' Show all available COM ports.
        For Each sp As String In My.Computer.Ports.SerialPortNames
            ComboBox_comport().Items.Add(sp)            ' Adds COMX to listbox called "comportselect"
        Next
        ComboBox_comport.Text = "Select COM Port"       ' Adds the message when program is first loaded
    End Sub

    Private Sub ComboBox_comport_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox_comport.SelectedIndexChanged
        connected = False
        If (serialport.IsOpen) Then                                                                 ' If program has previously opened a COM port, start by closing it
            serialport.Close()
        End If
        Try
            serialport = My.Computer.Ports.OpenSerialPort(ComboBox_comport.Text, 19200, 0, 8, 2)    ' attempt to open a new COM port
        Catch                                                                                       ' Catch open failures
            MessageBox.Show("Failed to open COM port", "ERRROR!", MessageBoxButtons.OKCancel, MessageBoxIcon.Asterisk)
            Return
        End Try
        serialport.ReadTimeout = 1000                                                               ' We will only arrive here on successfull open

        serBuf(0) = &H5A                                                                            ' Get id and firmware version
        transmit(1)
        receive(2)

        Dim idstr As String = String.Format("Module ID:{0}", serBuf(0))
        Dim verstr As String = String.Format("Firmware v:{0}", serBuf(1))
        Label_id.Text = idstr
        Label_v.Text = verstr

        serBuf(0) = &H82                                                                            ' Get ADC reference values
        transmit(1)
        receive(8)

        ComboBox_adc1.SelectedIndex = serBuf(0)
        ComboBox_adc2.SelectedIndex = serBuf(1)
        ComboBox_adc3.SelectedIndex = serBuf(2)
        ComboBox_adc4.SelectedIndex = serBuf(3)
        ComboBox_adc5.SelectedIndex = serBuf(4)
        ComboBox_adc6.SelectedIndex = serBuf(5)
        ComboBox_adc7.SelectedIndex = serBuf(6)
        ComboBox_adc8.SelectedIndex = serBuf(7)

        Button_relay_1.Enabled = True
        Button_relay_2.Enabled = True
        Timer1.Enabled = True
        connected = True
    End Sub

    Private Sub transmit(num As Integer)
        If serialport.IsOpen Then
            Try
                serialport.Write(serBuf, 0, num)        ' writes specified amount of SerBuf out on COM port
            Catch
                serialport.Close()
                Timer1.Enabled = False
                MessageBox.Show("Failed to read from COM port", "ERROR!", MessageBoxButtons.OKCancel, MessageBoxIcon.Asterisk)
                Return
            End Try
        End If
    End Sub

    Private Sub receive(num As Integer)
        If serialport.IsOpen Then
            Dim x As Integer = 0
            For x = 0 To num - 1                           ' Call the read function for passed number of times
                Try                                     ' This way we receive the correct number of bytes while still using timeouts
                    serialport.Read(serBuf, x, 1)
                Catch ex As Exception
                    serialport.Close()
                    Timer1.Enabled = False
                    MessageBox.Show("Failed to read from COM port", "ERROR!", MessageBoxButtons.OKCancel, MessageBoxIcon.Asterisk)
                End Try
            Next x
        End If
    End Sub

    Private Sub Timer1_Tick(sender As Object, e As EventArgs) Handles Timer1.Tick
        If connected = True Then
            serBuf(0) = &H5B
            transmit(1)
            receive(1)
            states = serBuf(0)

            serBuf(0) = &H80
            transmit(1)
            receive(16)

            adc1 = serBuf(0)
            adc1 <<= 8
            adc1 += serBuf(1)
            adc2 = serBuf(2)
            adc2 <<= 8
            adc2 += serBuf(3)
            adc3 = serBuf(4)
            adc3 <<= 8
            adc3 += serBuf(5)
            adc4 = serBuf(6)
            adc4 <<= 8
            adc4 += serBuf(7)
            adc5 = serBuf(8)
            adc5 <<= 8
            adc5 += serBuf(9)
            adc6 = serBuf(10)
            adc6 <<= 8
            adc6 += serBuf(11)
            adc7 = serBuf(12)
            adc7 <<= 8
            adc7 += serBuf(13)
            adc8 = serBuf(14)
            adc8 <<= 8
            adc8 += serBuf(15)

            Label1.Text = String.Format("ADC1: {0}", adc1)
            Label2.Text = String.Format("ADC2: {0}", adc2)
            Label3.Text = String.Format("ADC3: {0}", adc3)
            Label4.Text = String.Format("ADC4: {0}", adc4)
            Label5.Text = String.Format("ADC5: {0}", adc5)
            Label6.Text = String.Format("ADC6: {0}", adc6)
            Label7.Text = String.Format("ADC7: {0}", adc7)
            Label8.Text = String.Format("ADC8: {0}", adc8)


            ' Set button colours
            If states And &H1 Then
                Button_relay_1.BackColor = Color.Red
            Else
                Button_relay_1.BackColor = Color.White
            End If

            If states And &H2 Then
                Button_relay_2.BackColor = Color.Red
            Else
                Button_relay_2.BackColor = Color.White
            End If
        End If
    End Sub

    Private Sub button_pressed(sender As Object, e As EventArgs) Handles Button_relay_1.Click, Button_relay_2.Click
        If TypeOf sender Is Button Then                         ' Check that is is a button sending the message
            Dim btn As Button = DirectCast(sender, Button)      ' Get the button
            If connected = True Then
                Select Case btn.Text                            ' Check buttons text to see what relay we are expecting to toggle
                    Case "Relay 1"
                        If states And &H1 Then                  ' Check state of relay to see if we need to turn it on or off
                            serBuf(0) = &H6F                    ' Relay 1 on command
                        Else
                            serBuf(0) = &H65                    ' Relay 1 off command
                        End If
                    Case "Relay 2"
                        If states And &H2 Then
                            serBuf(0) = &H70
                        Else
                            serBuf(0) = &H66
                        End If
                End Select
                transmit(1)
            End If
        End If
    End Sub

    Private Sub adc_ref_selected(sender As Object, e As EventArgs) Handles ComboBox_adc1.SelectedIndexChanged, ComboBox_adc2.SelectedIndexChanged, ComboBox_adc3.SelectedIndexChanged, ComboBox_adc4.SelectedIndexChanged, ComboBox_adc5.SelectedIndexChanged, ComboBox_adc6.SelectedIndexChanged, ComboBox_adc7.SelectedIndexChanged, ComboBox_adc8.SelectedIndexChanged
        If TypeOf sender Is ComboBox Then
            Dim box As ComboBox = DirectCast(sender, ComboBox)
            If connected = True Then
                Dim ref As Byte
                serBuf(0) = &H81
                Select Case box.Tag
                    Case 1
                        ref = ComboBox_adc1.SelectedIndex
                        serBuf(1) = 1
                    Case 2
                        ref = ComboBox_adc2.SelectedIndex
                        serBuf(1) = 2
                    Case 3
                        ref = ComboBox_adc3.SelectedIndex
                        serBuf(1) = 3
                    Case 4
                        ref = ComboBox_adc4.SelectedIndex
                        serBuf(1) = 4
                    Case 5
                        ref = ComboBox_adc5.SelectedIndex
                        serBuf(1) = 5
                    Case 6
                        ref = ComboBox_adc6.SelectedIndex
                        serBuf(1) = 6
                    Case 7
                        ref = ComboBox_adc7.SelectedIndex
                        serBuf(1) = 7
                    Case 8
                        ref = ComboBox_adc8.SelectedIndex
                        serBuf(1) = 8
                End Select
                serBuf(2) = ref
                transmit(3)
            End If
        End If
    End Sub

End Class
