/*********************************************************
*         MD22 Example program for PIC24FJ16GA002        *
*	   Runs both motors at a set speed and uses the      *
*		      turn register to alter their speed         *
*				   By James Henderson 2009				 *
*********************************************************/

#include <p24fxxxx.h> 
#include "MD22.h"
#include "stdlib.h"
#include "stdio.h"

_CONFIG1(FWDTEN_OFF & JTAGEN_OFF & GCP_ON)
_CONFIG2(FNOSC_FRCPLL & OSCIOFNC_ON & IOL1WAY_ON & I2C1SEL_SEC) 

int main(void) 
{
extern unsigned char s[21];
extern unsigned char buffer[36];
unsigned char x;
	setup_cpu();										// General chip setup
	StartTimer(0x493E);									// Pause to wait for everything to  power up
	WaitTimer();
	read_i2c_buffer(0xB0, 7,1);							// read software version Placing it in buffer[0]
	setup_lcd();										// Clear the lcd screen and hide the cursor
	sprintf(s,"MD22 software v: %2d",buffer[0]);		// makes an ascii formatted string in s[]
	write_i2c_s_string(0xc6,0);							// sends ascii string s[] to lcd03 
	write_i2c(0xB0,0,2);								// set the MD22 mode to 2, controll both motors with speed1 register

	while(1)											// Loop here forever
	{
		for(x=0; x<250; x+=5)
		{
			StartTimer(6250);							// Start a timer running for 100mS to slow loop time down
			write_i2c(0xB0,1,100);						// set the MD22 speed
			write_i2c(0xB0,2,x);						// set the MD22 turn
			set_cursor(21);
			read_i2c_buffer(0xB0, 1,2);					// read speed register and turn register placing them in buffer[0] and buffer[1]
			sprintf(s,"speed = %3d",buffer[0]);	
			write_i2c_s_string(0xc6,0);					// print ascii string to LCD03
			set_cursor(41);
			sprintf(s,"turn = %3d",buffer[1]);	
			write_i2c_s_string(0xc6,0);					// print ascii string to LCD03
			WaitTimer();
		}
		for(x=245; x>5; x-=5)
		{
			StartTimer(6250);							// Start a timer running for 100mS to slow loop time down
			write_i2c(0xB0,1,100);						// set the MD22 speed
			write_i2c(0xB0,2,x);						// set the MD22 turn
			set_cursor(21);
			read_i2c_buffer(0xB0, 1,2);					// read speed register and turn register placing them in buffer[0] and buffer[1]
			sprintf(s,"speed = %3d",buffer[0]);	
			write_i2c_s_string(0xc6,0);					// print ascii string to LCD03
			set_cursor(41);
			sprintf(s,"turn = %3d",buffer[1]);	
			write_i2c_s_string(0xc6,0);					// print ascii string to LCD03
			WaitTimer();
		}
	}
	return(0);
}

/**********************************
* Timer routines
**********************************/
void StartTimer(unsigned int time)
{
	TMR1 = 0;						// Reset timer to 0
	PR1 = time;						// Timer1 period set
	IFS0bits.T1IF = 0;				// Clears Timer 1 interupt flag
	IEC0bits.T1IE = 0;				// Disable timer 1 interupts 
	T1CONbits.TON = 1;				// Starts timer
}

void WaitTimer(void)
{
	while(!IFS0bits.T1IF);			// While the interupt flag is not set
	T1CONbits.TON = 0;				// Stop timer
}

/**************************************
* General Chip setup
**************************************/
void setup_cpu(void)
{
	CLKDIV = 0x0000;				// 8MHz to PLL, 32MHz out = 16MIPs
	T1CON = 0x30;					// 1:256 prescaler
	AD1PCFG = 0x9fff;				
}	



